# Sahha x Convex Webhooks Starter

Stream health data from Sahha into Convex using HTTP Actions and Webhooks.

## Quick start

1. Install dependencies:

```bash
npm install
```

2. Start the Convex dev server (creates your project and deploys schema + functions):

```bash
npx convex dev
```

When prompted, select **create a new project** and give it a name.

3. Set your Sahha webhook secret:

```bash
npx convex env set SAHHA_WEBHOOK_SECRET your_secret
```

4. Deploy to production:

```bash
npx convex deploy
```

5. Your webhook endpoint URL is:

```
https://<deployment>.convex.site/sahha-webhook
```

Use this URL as the **Destination URL** when creating a webhook in the Sahha dashboard.

## Project structure

```
convex/
  schema.ts      — sahhaEvents table definition + indexes
  webhooks.ts    — internalMutation: dedup check + insert event
  http.ts        — HTTP router with POST /sahha-webhook, HMAC verification
```

## Full guide

See the complete integration guide at: https://sahha.ai/resources/build/convex-health-data-streaming/
