import { defineSchema, defineTable } from "convex/server";
import { v } from "convex/values";

export default defineSchema({
  sahhaEvents: defineTable({
    eventType: v.string(),
    externalId: v.string(),
    payload: v.any(),
    eventHash: v.string(),
    receivedAt: v.number(),
  })
    .index("by_event_hash", ["eventHash"])
    .index("by_external_id", ["externalId"])
    .index("by_event_type", ["eventType"]),
});
