import { internalMutation } from "./_generated/server";
import { v } from "convex/values";

export const store = internalMutation({
  args: {
    eventType: v.string(),
    externalId: v.string(),
    payload: v.any(),
    eventHash: v.string(),
  },
  handler: async (ctx, args) => {
    const existing = await ctx.db
      .query("sahhaEvents")
      .withIndex("by_event_hash", (q) => q.eq("eventHash", args.eventHash))
      .first();

    if (existing) {
      return;
    }

    await ctx.db.insert("sahhaEvents", {
      ...args,
      receivedAt: Date.now(),
    });
  },
});
