# Sahha → Firebase Webhooks Starter (Cloud Functions + Firestore)

This starter is designed to deploy cleanly with Firebase **Cloud Functions (TypeScript)** and store Sahha webhook events in **Firestore**.

## What’s included (so you don’t have to run `firebase init`)

- `firebase.json` with a **predeploy build step** (TypeScript compiles automatically on deploy)
- `functions/tsconfig.json` configured to compile `src/` → `lib/`
- `functions/package.json` with `main: lib/index.js` (what Firebase deploys)
- `functions/src/index.ts` exporting `sahhaWebhook`

## Quick start

```bash
npm install -g firebase-tools
firebase login

# unzip and enter project
cd sahha-firebase-webhooks-starter

# pick your firebase project
firebase use --add

# install deps + deploy
cd functions
npm install
cd ..

firebase functions:secrets:set SAHHA_WEBHOOK_SECRET
firebase deploy --only functions
```

After deploy, use the function URL (Trigger URL) as the Sahha webhook **Destination URL**.

## Firestore path

Events are stored at:

```
sahha_events/{eventType}/events/{eventHash}
```
