# Sahha → Supabase Webhooks Starter (Edge Functions + Postgres)

This starter is designed to deploy cleanly with Supabase **Edge Functions (Deno/TypeScript)** and store Sahha webhook events in **Postgres**.

## What's included

- `supabase/config.toml` — Supabase project configuration
- `supabase/functions/sahha-webhook/index.ts` — Edge Function that verifies webhook signatures and inserts events
- `supabase/migrations/001_create_sahha_events.sql` — creates the `sahha_events` table with deduplication

## Quick start

```bash
npm i supabase --save-dev

# unzip and enter project
cd sahha-supabase-webhooks-starter

# authenticate with Supabase
npx supabase login

# link to your Supabase project (find your project ID in Dashboard → Project Settings → General)
npx supabase link --project-ref your-project-id

# apply the database migration
npx supabase db push

# set your webhook secret (replace with your actual secret from Sahha)
npx supabase secrets set SAHHA_WEBHOOK_SECRET=your_secret_here

# deploy the edge function
npx supabase functions deploy sahha-webhook
```

After deploy, use the function URL as the Sahha webhook **Destination URL**.

## Database table

Events are stored in the `sahha_events` table:

| Column | Type | Description |
|---|---|---|
| `id` | bigint | Auto-incrementing primary key |
| `event_type` | text | Sahha event type from `X-Event-Type` header |
| `external_id` | text | User identifier from `X-External-Id` header |
| `payload` | jsonb | Full event payload |
| `event_hash` | text | SHA-256 hash of the raw body (unique, used for dedup) |
| `created_at` | timestamptz | Timestamp when the event was received |
