create table if not exists sahha_events (
  id bigint generated always as identity primary key,
  event_type text not null,
  external_id text not null default '',
  payload jsonb not null default '{}',
  event_hash text not null,
  created_at timestamptz not null default now(),
  constraint sahha_events_event_hash_unique unique (event_hash)
);

create index if not exists idx_sahha_events_event_type on sahha_events (event_type);
create index if not exists idx_sahha_events_external_id on sahha_events (external_id);
